/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;
import com.quantumdata.widgets.QDComboBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FmtComboBox
extends QDComboBox {
    private CmdValue m_value = null;

    public FmtComboBox() {
        this.init(null);
    }

    public FmtComboBox(CmdValue cmdValue) {
        this.init(cmdValue);
    }

    public FmtComboBox(Object[] objectArray) {
        super(objectArray);
        this.init(null);
    }

    private void init(CmdValue cmdValue) {
        this.m_value = cmdValue;
        if (this.m_value != null) {
            this.setEnumValues(this.m_value.getEnumValues());
            this.selectValue(this.m_value.getInt());
            this.setToolTipText("Set " + cmdValue.getCmd());
        }
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FmtComboBox.this.selectionChanged();
            }
        });
    }

    protected void selectionChanged() {
        if (this.m_value == null) {
            return;
        }
        NamedValue namedValue = (NamedValue)this.getSelectedItem();
        if (namedValue == null) {
            return;
        }
        this.m_value.setInt(namedValue.value());
    }

    protected void setEnumValues(NamedValue[] namedValueArray) {
        this.removeAllItems();
        if (namedValueArray == null) {
            return;
        }
        for (NamedValue namedValue : namedValueArray) {
            this.addItem(namedValue);
        }
    }

    public void selectValue(int n) {
        if (this.getItemCount() == 0) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            NamedValue namedValue = (NamedValue)this.getItemAt(i);
            if (namedValue.value() != n) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedIndex(0);
    }
}

